package editor;

import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class BackgroundPreviewPopupPanel extends JPanel implements Runnable{

	private ListModel listModel;
	private int currentFrame;
	private boolean shouldNotStop = true;
	private boolean isWide = false;
	
	public BackgroundPreviewPopupPanel(ListModel theListModel) {
		listModel = theListModel;
		shouldNotStop = true;
		currentFrame = 0;
		
		this.setSize(500, 500);
	}
	
	public BackgroundPreviewPopupPanel(ListModel theListModel, boolean wide) {
		listModel = theListModel;
		shouldNotStop = true;
		currentFrame = 0;
		isWide = wide;
		
		if(wide) {
			this.setSize(700, 500);
		} else {
			this.setSize(500, 500);
		}
	}

	public void run() {
		
		while(shouldNotStop) {
			
			repaint();
			
			try {
				Thread.sleep(100L);
			} catch (InterruptedException e) {
				
			}
			
		}
		
	}
	
	public void paintComponent(Graphics g) {
		
		ListedImage li = (ListedImage) listModel.getElementAt(currentFrame);
		
		if(isWide) {
			g.drawImage(li.getImage(), 0, 0, 700, 500, null);
		} else {
			g.drawImage(li.getImage(), 0, 0, 500, 500, null);
		}
		
		currentFrame++;
		
		if(currentFrame >= listModel.getSize()) {
			currentFrame = 0;
		}
		
	}
	
	public void stopCycling() {
		shouldNotStop = false;
	}
	
	public static void showPopUp(ListModel theListModel) {
		
		
		final BackgroundPreviewPopupPanel panel = new BackgroundPreviewPopupPanel(theListModel);
		
		JFrame theFrame = new JFrame();
		
		theFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				panel.stopCycling();
			}
		});
		
		theFrame.setSize(508, 557);
		
		theFrame.setContentPane(panel);
		
		theFrame.setVisible(true);
		
		
		
		
		Thread thread = new Thread(panel);
		thread.start();
		
		
	}
	
	public static void showWidePopUp(ListModel theListModel) {
		
		
		final BackgroundPreviewPopupPanel panel = new BackgroundPreviewPopupPanel(theListModel, true);
		
		JDialog theFrame = new JDialog();
		
		theFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				panel.stopCycling();
			}
		});
		
		theFrame.setSize(703, 557);
		
		theFrame.setContentPane(panel);

		Thread thread = new Thread(panel);
		thread.start();
		
		theFrame.setModal(true);
		theFrame.setVisible(true);
		
		
		theFrame.dispose();
		
		
	}
	
	
}
